<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'title',
    [
        'label' => __('Add Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Contact', 'ogency-addon')
    ]
);

ogency_elementor_heading_option($this, 'Section Title', 'h3', 'layout_one');


$footer_contact_list = new \Elementor\Repeater();

$footer_contact_list->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default title', 'ogency-addon'),
    ]
);

$footer_contact_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fas fa-map-marker',
            'library' => 'custom-icon',
        ],
    ]
);

$footer_contact_list->add_control(
    'content',
    [
        'label' => __('Content', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Content', 'ogency-addon'),
        'default' => __('Default Content', 'ogency-addon'),
    ]
);

$this->add_control(
    'footer_contact_list',
    [
        'label' => __('Contact Info', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $footer_contact_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
