<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$feature_list = new \Elementor\Repeater();

$feature_list->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($feature_list, 'Feature Title', 'h4', 'layout_one');

$feature_list->add_control(
    'summary',
    [
        'label' => __('Summary Text', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Summary Text', 'ogency-addon'),
        'default' => __('Default Text', 'ogency-addon'),
    ]
);

$feature_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-idea',
            'library' => 'custom-icon',
        ],
    ]
);

$feature_list->add_control(
    'image',
    [
        'label' => __('Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$feature_list->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Button Label', 'ogency-addon'),
        'label_block' => true,
    ]
);

$feature_list->add_control(
    'url',
    [
        'label' => __('Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$feature_list->add_control(
    'btn_icon',
    [
        'label' => __('Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-down-right',
            'library' => 'Custom Icon',
        ],
    ]
);

$this->add_control(
    'feature_list_one',
    [
        'label' => __('feature Lists', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $feature_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
