<?php

//content
$this->start_controls_section(
    'layout_two_content',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);


$this->add_control(
    'layout_two_sec_title',
    [
        'label' => __('Section Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Title', 'h2', 'layout_two');

$this->add_control(
    'layout_two_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'ogency-addon'),
        'default' => __('Default Sub Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Sub Title', 'h5', 'layout_two');


$this->add_control(
    'layout_two_highlighted_text',
    [
        'label' => __('Highlighted Text', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Highlighted Text', 'ogency-addon'),
        'default' => __('Default Highlighted Text', 'ogency-addon'),
    ]
);

$this->add_control(
    'layout_two_summary',
    [
        'label' => __('Summary', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Text', 'ogency-addon'),
        'default' => __('Default Summary Text', 'ogency-addon'),
    ]
);

$this->add_control(
    'about_two_summary_hr',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$this->add_control(
    'layout_two_name',
    [
        'label' => __('Name', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '1',
        'placeholder' => __('Add Name', 'ogency-addon'),
        'default' => __('Christine', 'ogency-addon'),
    ]
);

$this->add_control(
    'layout_two_designation',
    [
        'label' => __('Designation', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '1',
        'placeholder' => __('Add Designation', 'ogency-addon'),
        'default' => __('Christine Eve - Founder', 'ogency-addon'),
    ]
);


$layout_two_counter = new \Elementor\Repeater();

$layout_two_counter->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
        'label_block' => true
    ]
);


ogency_elementor_heading_option($layout_two_counter, 'Counter Title', 'h3', 'layout_two');

$layout_two_counter->add_control(
    'number',
    [
        'label' => __('Number', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add number', 'ogency-addon'),
        'default' => __('89', 'ogency-addon'),
        'label_block' => true
    ]
);

$layout_two_counter->add_control(
    'symbol',
    [
        'label' => __('Symbol', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add symbol', 'ogency-addon'),
        'default' => __('k', 'ogency-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'layout_two_counter_list',
    [
        'label' => __('Counter List', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_counter->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);


$this->add_control(
    'layout_two_bg_shape',
    [
        'label' => __('Background Shape', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'layout_two_signature_image',
    [
        'label' => __('Signature Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->end_controls_section();
