<?php

/**
 * Template part for displaying Page Header
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package ogency
 */
?>
<?php
$ogency_page_header_extra_class = apply_filters('ogency_page_header_extra_class', 'page-header--unit-test');
?>
<!--Page Header Start-->
<section class="page-header <?php echo esc_attr($ogency_page_header_extra_class); ?>">
	<div class="page-header__bg"></div>
	<div class="page-header__overlay"></div>
	<div class="container">
		<div class="page-header__inner">
			<?php $ogency_page_meta_breadcumb_status = empty(get_post_meta(get_the_ID(), 'ogency_show_page_breadcrumb', true)) ? 'on' : get_post_meta(get_the_ID(), 'ogency_show_page_breadcrumb', true); ?>
			<?php if (function_exists('bcn_display_list') && 'yes' == get_theme_mod('breadcrumb_opt', 'off') && 'on' == $ogency_page_meta_breadcumb_status) : ?>
				<ul class="thm-breadcrumb list-unstyled ml-0">
					<?php bcn_display_list(); ?>
				</ul>
			<?php endif; ?>
			<?php
			$ogency_page_title_text = !empty(get_post_meta(get_the_ID(), 'ogency_set_header_title', true)) ? get_post_meta(get_the_ID(), 'ogency_set_header_title', true) : get_the_title();
			$ogency_page_header_tag = apply_filters('ogency_page_header_tag', 'h2');
			?>
			<<?php echo esc_attr($ogency_page_header_tag); ?>>
				<?php if (!is_page()) : ?>
					<?php ogency_page_title(); ?>
				<?php else : ?>
					<?php echo wp_kses($ogency_page_title_text, 'ogency_allowed_tags') ?>
				<?php endif; ?>
			</<?php echo esc_attr($ogency_page_header_tag); ?>>
		</div>
	</div>
</section>
<!--Page Header End-->