<?php

/**
 * Template part for displaying footer
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package ogency
 */
?>


<?php
$ogency_page_id     = get_queried_object_id();
$ogency_custom_footer_status = !empty(get_post_meta($ogency_page_id, 'ogency_custom_footer_status', true)) ? get_post_meta($ogency_page_id, 'ogency_custom_footer_status', true) : 'off';

$ogency_custom_footer_id = '';
if ((is_page() && 'on' === $ogency_custom_footer_status) || (is_singular('portfolio') && 'on' === $ogency_custom_footer_status) || (is_singular('service') && 'on' === $ogency_custom_footer_status) || (is_singular('team') && 'on' === $ogency_custom_footer_status)) {
    $ogency_custom_footer_id = get_post_meta($ogency_page_id, 'ogency_select_custom_footer', true);
} elseif ('yes' == get_theme_mod('footer_custom')) {
    $ogency_custom_footer_id = get_theme_mod('footer_custom_post');
} else {
    $ogency_custom_footer_id = 'default_footer';
}

$ogency_dynamic_footer = isset($_GET['custom_footer_id']) ? $_GET['custom_footer_id'] : $ogency_custom_footer_id;
?>


<?php if ('default_footer' == $ogency_dynamic_footer) : ?>
    <div class="site-footer__bottom default-footer">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-footer__bottom-inner">
                        <p class="site-footer__bottom-text"><?php echo wp_kses(get_theme_mod('footer_copytext', esc_html__('&copy; All Copyright 2023 by Ogency', 'ogency')), 'ogency_allowed_tags'); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php else : ?>
    <?php echo do_shortcode('[ogency-footer id="' . $ogency_dynamic_footer . '"]');
    ?>
<?php endif; ?>