<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package ogency
 */
$tag_name = get_the_tags();
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="blog-details__content">
		<div class="blog-details__content_inner overflow-hidden">
			<?php if (has_post_thumbnail()) : ?>
				<div class="blog-details__img<?php if (function_exists('ogency_elementor_rendered_image')) {
													echo esc_attr(" blend_mode");
												} ?>">
					<?php the_post_thumbnail('ogency_blog_770X428'); ?>
					<span class="blog-details__img__date"><?php echo get_the_date(); ?></span>
				</div>
			<?php endif; ?>
			<?php if (has_tag()) : ?>
				<div class="blog-details__meta">
					<a href="<?php the_permalink(); ?>"><?php echo esc_html($tag_name[0]->name); ?></a>
					<?php if (!empty(get_comments_number())) : ?><span class="dot">.</span><?php ogency_comment_count(); ?><?php endif; ?>
				</div><!-- /.details-meta -->
			<?php else : ?>
				<div class="blog-details__meta">
					<?php ogency_comment_count(); ?>
				</div><!-- /.details-meta -->
			<?php endif; ?>

			<?php
			the_content(
				sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__('Continue reading<span class="screen-reader-text"> "%s"</span>', 'ogency'),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					wp_kses_post(get_the_title())
				)
			);

			wp_link_pages(
				array(
					'before' => '<div class="page-links">' . esc_html__('Pages:', 'ogency'),
					'after'  => '</div>',
				)
			);
			?>
		</div>
		<div class="news-details__bottom blog-details__bottom">
			<?php ogency_entry_footer(); ?>
		</div>

	</div>

</article><!-- #post-<?php the_ID(); ?> -->