<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package ogency
 */
$tag_name = get_the_tags();
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('blog-one__item blog-one__item-list'); ?>>
	<?php if (has_post_thumbnail()) : ?>
		<div class="blog-one__item__image<?php if (function_exists('ogency_elementor_rendered_image')) {
												echo esc_attr(" blend_mode");
											} ?>">
			<?php the_post_thumbnail('ogency_blog_770X428');  ?>
			<a href="<?php the_permalink(); ?>"></a>
			<span><?php echo get_the_date(); ?></span>
		</div><!-- /.blog-image -->
	<?php endif; ?>
	<div class="blog-one__item__content">
		<?php if (has_tag()) : ?>
			<div class="blog-one__item__meta has-border">
				<a href="<?php the_permalink(); ?>"><?php echo esc_html($tag_name[0]->name); ?></a><?php if (!empty(get_comments_number())) : ?><span class="dot">.</span><?php ogency_comment_count(); ?><?php endif; ?>
			</div><!-- /.blog-meta -->
		<?php else : ?>
			<div class="blog-one__item__meta has-border">
				<?php ogency_comment_count(); ?>
			</div><!-- /.blog-meta -->
		<?php endif; ?>
		<h3 class="blog-one__item__title">
			<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
		</h3><!-- /.blog-title -->
		<?php $ogency_excerpt_count = apply_filters('ogency_excerpt_count', 39); ?>
		<p class="blog-one__item__text"><?php ogency_excerpt($ogency_excerpt_count); ?></p>
		<a class="blog-one__item__btn" href="<?php the_permalink(); ?>"><?php esc_html_e('Read More', 'ogency'); ?><span class="icon-down-right"></span></a><!-- /.blog-read-more -->
	</div><!-- /.blog-content -->
</article><!-- #post-<?php the_ID(); ?> -->