<?php

/**
 * ogency functions for getting inline styles from theme customizer
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package ogency
 */

if (!function_exists('ogency_theme_customizer_styles')) :
	function ogency_theme_customizer_styles()
	{

		// ogency color option

		$ogency_inline_style = '';
		$ogency_inline_style .= ':root {
			--ogency-primary: ' . get_theme_mod('theme_primary_color', sanitize_hex_color('#f2edea')) . ';
			--ogency-primary-rgb: ' . ogency_hex_to_rgb(get_theme_mod('theme_primary_color', sanitize_hex_color('#f2edea'))) . ';

			--ogency-base: ' . get_theme_mod('theme_base_color', sanitize_hex_color('#f5900d')) . ';
			--ogency-base-rgb: ' . ogency_hex_to_rgb(get_theme_mod('theme_base_color', sanitize_hex_color('#f5900d'))) . ';

			--ogency-black: ' . get_theme_mod('theme_black_color', sanitize_hex_color('#000000')) . ';
			--ogency-black-rgb: ' . ogency_hex_to_rgb(get_theme_mod('theme_black_color', sanitize_hex_color('#000000'))) . ';
		}';

		$ogency_inner_banner_bg = get_theme_mod('page_header_bg_image');
		$ogency_inner_overlay_bg = get_theme_mod('page_header_overlay_image');

		$ogency_inline_style .= '.page-header__bg { background-image: url(' . $ogency_inner_banner_bg . '); } ';
		$ogency_inline_style .= '.page-header__overlay { background-image: url(' . $ogency_inner_overlay_bg . '); } ';

		$ogency_preloader_icon = get_theme_mod('preloader_image');
		if ($ogency_preloader_icon) {
			$ogency_inline_style .= '.preloader .preloader__image { background-image: url(' . $ogency_preloader_icon . '); } ';
		}

		if (is_page()) {


			$ogency_page_primary_color = empty(get_post_meta(get_the_ID(), 'ogency_primary_color', true)) ? get_theme_mod('theme_primary_color', sanitize_hex_color('#f2edea')) : get_post_meta(get_the_ID(), 'ogency_primary_color', true);

			$ogency_page_base_color = empty(get_post_meta(get_the_ID(), 'ogency_base_color', true)) ? get_theme_mod('theme_base_color', sanitize_hex_color('#976147')) : get_post_meta(get_the_ID(), 'ogency_base_color', true);

			$ogency_page_black_color = empty(get_post_meta(get_the_ID(), 'ogency_black_color', true)) ? get_theme_mod('theme_black_color', sanitize_hex_color('#1a1414')) : get_post_meta(get_the_ID(), 'ogency_black_color', true);

			$ogency_page_secondary_color = empty(get_post_meta(get_the_ID(), 'ogency_secondary_color', true)) ? get_theme_mod('theme_secondary_color', sanitize_hex_color('#5b4034')) : get_post_meta(get_the_ID(), 'ogency_secondary_color', true);

			$ogency_inline_style .= ':root {
				--ogency-primary: ' . $ogency_page_primary_color . ';
				--ogency-primary-rgb: ' . ogency_hex_to_rgb($ogency_page_primary_color) . ';
				--ogency-base: ' . $ogency_page_base_color . ';
				--ogency-base-rgb: ' . ogency_hex_to_rgb($ogency_page_base_color) . ';
				--ogency-black: ' . $ogency_page_black_color . ';
				--ogency-black-rgb: ' . ogency_hex_to_rgb($ogency_page_black_color) . ';
				--ogency-secondary: ' . $ogency_page_secondary_color . ';
				--ogency-secondary-rgb: ' . ogency_hex_to_rgb($ogency_page_secondary_color) . ';
			}';

			$ogency_page_header_bg = empty(get_post_meta(get_the_ID(), 'ogency_set_header_image', true)) ? get_theme_mod('page_header_bg_image') : get_post_meta(get_the_ID(), 'ogency_set_header_image', true);

			$ogency_inline_style .= '.page-header__bg { background-image: url(' . $ogency_page_header_bg . '); }';
		}

		if (is_singular('post')) {
			$ogency_post_header_bg = empty(get_post_meta(get_the_ID(), 'ogency_set_header_image', true)) ? get_theme_mod('page_header_bg_image') : get_post_meta(get_the_ID(), 'ogency_set_header_image', true);

			$ogency_inline_style .= '.page-header__bg  { background-image: url(' . $ogency_post_header_bg . '); }';
		}


		wp_add_inline_style('ogency-style', $ogency_inline_style);
	}
endif;

add_action('wp_enqueue_scripts', 'ogency_theme_customizer_styles');
