<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package ogency
 */

get_header();


?>

<?php if ('yes' == get_theme_mod('error_custom')) : ?>
    <?php echo do_shortcode(\Elementor\Plugin::$instance->frontend->get_builder_content(get_theme_mod('error_custom_post'))); ?>
<?php else : ?>
    <main id="primary" class="site-main">
        <!-- Error Start -->
        <section class="error-page<?php if (!function_exists('ogency_elementor_rendered_image')) {
                                        echo esc_attr(" default");
                                    } ?>">
            <div class="container">
                <div class="error-page__content">
                    <?php if (!empty(get_theme_mod('404_page_title_image'))) : ?>
                        <h1 class="error-page__404"><?php esc_html_e('404', 'ogency'); ?><img src="<?php echo esc_url(get_theme_mod('404_page_title_image')); ?>" alt="<?php echo esc_attr('404 image', 'ogency'); ?>"></h1><!-- 404 -->
                    <?php else : ?>
                        <h1 class="error-page__404"><?php esc_html_e('404', 'ogency'); ?></h1>
                    <?php endif; ?>
                    <h4 class="error-page__title"><?php esc_html_e('Oops! page not found', 'ogency'); ?></h4><!-- 404-title -->
                    <p class="error-page__text"><?php esc_html_e('The page you are looking for is not exist.', 'ogency'); ?></p><!-- 404-content -->
                    <form class="error-page__form" method="get" action="<?php echo esc_url(home_url()); ?>">
                        <div class="error-page__form-input">
                            <input type="search" name="s" placeholder="<?php esc_attr_e('Search here', 'ogency'); ?>">
                            <button type="submit"><i class="icon-magnifying-glass"></i></button>
                        </div>
                    </form>
                    <a href="<?php echo esc_url(home_url('/')); ?>" class="ogency-btn"><?php esc_html_e('Back to Home', 'ogency'); ?></a>
                </div><!-- 404-info -->
            </div>
        </section>
        <!-- Error End -->

    </main><!-- #main -->
<?php endif; ?>

<?php
get_footer();
