<?php
// Exit if accessed directly
if (!defined('ABSPATH')) exit;


/**
 * Setup My Child Theme's textdomain.
 *
 * Declare textdomain for this child theme.
 * Translations can be filed in the /languages/ directory.
 */
function ogency_child_theme_setup()
{
    load_child_theme_textdomain('ogency-child', get_stylesheet_directory() . '/languages');
}
add_action('after_setup_theme', 'ogency_child_theme_setup');

if (!function_exists('ogency_child_thm_parent_css')) :
    function ogency_child_thm_parent_css()
    {
        // loading parent styles
        wp_enqueue_style('ogency-parent-style', get_template_directory_uri() . '/style.css', array('ogency-fonts', 'ogency-icons', 'bootstrap', 'fontawesome'));

        // loading child style based on parent style
        wp_enqueue_style('ogency-style', get_stylesheet_directory_uri() . '/style.css', array('ogency-parent-style'));
    }

endif;
add_action('wp_enqueue_scripts', 'ogency_child_thm_parent_css');

// END ENQUEUE PARENT ACTION