<?php

namespace Layerdrops\Ogency\Widgets;


class Testimonials extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-testimonials';
    }

    public function get_title()
    {
        return __('Testimonials', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {


        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                    'layout_two' => __('Layout Two', 'ogency-addon'),
                    'layout_three' => __('Layout Three', 'ogency-addon'),
                    // 'layout_four' => __('Layout Four', 'ogency-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include ogency_get_elementor_option('testimonial-one-option.php');
        include ogency_get_elementor_option('testimonial-two-option.php');
        include ogency_get_elementor_option('testimonial-three-option.php');
        // include ogency_get_elementor_option('testimonial-four-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .case-details__review-title', ['layout_three']);
        ogency_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_three']);

        ogency_elementor_general_style_options($this, 'Name', '{{WRAPPER}} .testimonial-one__item__quote,{{WRAPPER}} .testimonial-two__item__meta,{{WRAPPER}} .testimonial-three__item__name', ['layout_one', 'layout_two', 'layout_three']);
        ogency_elementor_general_style_options($this, 'Designation', '{{WRAPPER}} .testimonial-one__item__meta', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Content', '{{WRAPPER}} .testimonial-one__item__meta span,{{WRAPPER}} .testimonial-two__item__quote, {{WRAPPER}} .testimonial-three__item__quote', ['layout_one', 'layout_two', 'layout_three']);


        $this->end_controls_section();

        ogency_get_elementor_carousel_options($this, ['layout_one', 'layout_three']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('testimonials-one.php');
        include ogency_get_template('testimonials-two.php');
        include ogency_get_template('testimonials-three.php');
        // include ogency_get_template('testimonials-four.php');
    }
}
