<?php

namespace Layerdrops\Ogency\Widgets;


class Sponsors extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-sponsors';
    }

    public function get_title()
    {
        return __('Sponsors', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                    'layout_two' => __('Layout Two', 'ogency-addon'),
                    // 'layout_three' => __('Layout Three', 'ogency-addon'),
                    // 'layout_four' => __('Layout Four', 'ogency-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Default Title', 'ogency-addon'),
                'label_block' => true,
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );
        $sponsor_images = new \Elementor\Repeater();

        $sponsor_images->add_control(
            'image',
            [
                'label' => __('Add Image', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'sponsor_images',
            [
                'label' => __('Sponsor Items', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $sponsor_images->get_controls(),
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .client-carousel__tilte span', ['layout_one']);

        $this->end_controls_section();

        ogency_get_elementor_carousel_options($this, ['layout_one', 'layout_two']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('sponsors-one.php');
        include ogency_get_template('sponsors-two.php');
        // include ogency_get_template('sponsors-three.php');
        // include ogency_get_template('sponsors-four.php');
    }
}
