<?php

namespace Layerdrops\Ogency\Widgets;


class SlidingText extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-sliding-text';
    }

    public function get_title()
    {
        return __('Sliding Text', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                    'layout_two' => __('Layout Two', 'ogency-addon'),
                    'layout_three' => __('Layout Three', 'ogency-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include ogency_get_elementor_option('sliding-text-option-one.php');
        include ogency_get_elementor_option('sliding-text-option-two.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .slider-text-one .slider-text-one__animate-text span,{{WRAPPER}} .sliding-text__list li', ['layout_one', 'layout_two']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('sliding-text-one.php');
        include ogency_get_template('sliding-text-two.php');
        include ogency_get_template('sliding-text-three.php');
    }
}
