<?php

namespace Layerdrops\Ogency\Widgets;


class ServiceDetails extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'ogency-service-details';
	}

	public function get_title()
	{
		return __('Service Details', 'ogency-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['ogency-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'ogency-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'ogency-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One (Image)', 'ogency-addon'),
				]
			]
		);

		$this->end_controls_section();

		include  ogency_get_elementor_option('service-details-one-option.php');
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include ogency_get_template('service-details-one.php');
	}
}
