<?php

namespace Layerdrops\Ogency\Widgets;


class Portfolio extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-portfolio';
    }

    public function get_title()
    {
        return __('Portfolio', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                    'layout_two' => __('Layout Two', 'ogency-addon'),
                    'layout_three' => __('Layout Three', 'ogency-addon'),
                    'layout_four' => __('Layout Four', 'ogency-addon'),
                    'layout_five' => __('Layout Five', 'ogency-addon'),
                    'layout_six' => __('Layout Six', 'ogency-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include ogency_get_elementor_option('portfolio-one-option.php');
        include ogency_get_elementor_option('portfolio-two-option.php');
        include ogency_get_elementor_option('portfolio-three-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two']);
        ogency_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two']);

        ogency_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .project-one__item__title,{{WRAPPER}} .project-two__item__content__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        ogency_elementor_general_style_options($this, 'Tagline', '{{WRAPPER}} .project-two__item__content__cats a', ['layout_two', 'layout_three', 'layout_four', 'layout_five']);

        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_type' => ['layout_one']
                ]
            ]
        );

        ogency_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .ogency-btn', '.ogency-btn::after', ['layout_one']);

        $this->end_controls_section();

        ogency_get_elementor_carousel_options($this, ['layout_two', 'layout_four']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('portfolio-one.php');
        include ogency_get_template('portfolio-two.php');
        include ogency_get_template('portfolio-three.php');
        include ogency_get_template('portfolio-four.php');
        include ogency_get_template('portfolio-five.php');
        include ogency_get_template('portfolio-six.php');
    }
}
