<?php

namespace Layerdrops\Ogency\Widgets;


class Faq extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'ogency-faq';
	}

	public function get_title()
	{
		return __('FAQ', 'ogency-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['ogency-category'];
	}

	protected function register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'ogency-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'ogency-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'ogency-addon'),
				]
			]
		);

		$this->end_controls_section();

		include ogency_get_elementor_option('faq-one-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Content Style', 'ogency-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		ogency_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__tagline.section-title__tagline--has-dots', ['layout_one']);
		ogency_elementor_general_style_options($this, 'Section Subtitle', '{{WRAPPER}} .section-title__title', ['layout_one']);

		ogency_elementor_general_style_options($this, 'Question', '{{WRAPPER}} .faq-page__accrodion .accrodion-title h4', ['layout_one']);
		ogency_elementor_general_style_options($this, 'Answer', '{{WRAPPER}} .faq-page .faq-one-accrodion .accrodion-content p', ['layout_one']);
		ogency_elementor_general_style_options($this, 'Contact Title', '{{WRAPPER}} .faq-page__help__title', ['layout_one']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include ogency_get_template('faq-one.php');
	}
}
