<?php

namespace Layerdrops\Ogency\Widgets;


class About extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'ogency-about';
	}

	public function get_title()
	{
		return __('About', 'ogency-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['ogency-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'ogency-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'ogency-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'ogency-addon'),
					'layout_two' => __('Layout Two', 'ogency-addon'),
					'layout_three' => __('Layout Three', 'ogency-addon'),
				]
			]
		);

		$this->end_controls_section();

		include ogency_get_elementor_option('about-one-option.php');
		include ogency_get_elementor_option('about-two-option.php');
		include ogency_get_elementor_option('about-three-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('featurogencyContent Style', 'ogency-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		ogency_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_three']);
		ogency_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two', 'layout_three']);

		ogency_elementor_general_style_options($this, 'Summary Text One', '{{WRAPPER}} .about-one__content__text-one,{{WRAPPER}} .about-two__right--text,{{WRAPPER}} .about-three__content__heading', ['layout_one', 'layout_two', 'layout_three']);
		ogency_elementor_general_style_options($this, 'Summary Text Two', '{{WRAPPER}} .about-one__content__text-two,{{WRAPPER}} .about-two__right--quote,{{WRAPPER}} .about-three__content__text', ['layout_one', 'layout_two', 'layout_three']);

		ogency_elementor_general_style_options($this, 'Designation', '{{WRAPPER}} .about-two__left--text,{{WRAPPER}} .about-three__author__meta', ['layout_two', 'layout_three']);
		ogency_elementor_general_style_options($this, 'Counter Title', '{{WRAPPER}} .fact-one__item__title', ['layout_two']);
		ogency_elementor_general_style_options($this, 'Counter Number', '{{WRAPPER}} .fact-one__item__count', ['layout_two']);

		$this->end_controls_section();

		//button style
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('Button Style', 'ogency-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout_type' => ['layout_one']
				]
			]
		);

		ogency_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .ogency-btn', '{{WRAPPER}} .ogency-btn:before', ['layout_one']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include ogency_get_template('about-one.php');
		include ogency_get_template('about-two.php');
		include ogency_get_template('about-three.php');
	}
}
