<?php if ('layout_four' == $settings['layout_type']) : ?>

    <!-- Team Four Start -->
    <section class="team-one team-one--carousel">
        <div class="container">
            <div class="ogency-owl__dots ogency-owl__carousel owl-theme owl-carousel" data-owl-options='<?php echo esc_attr(ogency_get_owl_options($settings)); ?>'>
                <?php
                foreach ($settings['team_layout_four_list'] as $index => $item) : ?>
                    <div class="item">
                        <div class="team-one__item">
                            <div class="team-one__item__image">
                                <?php ogency_elementor_rendered_image($item, 'image'); ?>
                            </div><!-- /.team-image -->
                            <div class="team-one__item__content">
                                <?php
                                if (!empty($item['designation'])) :
                                    ogency_basic_rendered_content($this, $item,  'designation', 'team-one__item__designation', 'span');
                                endif;
                                ?>
                                <<?php echo esc_attr($item['team_name_tag_layout_four']); ?> class="team-one__item__title">
                                    <?php
                                    if (!empty($item['name'])) :
                                        ogency_basic_rendered_content($this, $item,  'name', '', 'a');
                                    endif;
                                    ?>
                                </<?php echo esc_attr($item['team_name_tag_layout_four']); ?>><!-- /.team-name -->
                                <div class="team-one__item__social-wrapper">
                                    <a class="team-one__item__links" href="#"><span class="fas fa-share-alt"></span></a><!-- /.social-more -->
                                    <div class="team-one__item__social">
                                        <?php echo wp_kses($item['social_network'], 'ogency_allowed_tags'); ?>
                                    </div><!-- /.team-social -->
                                </div>
                            </div><!-- /.team-content -->
                        </div><!-- /.team-one -->
                    </div>
                <?php
                endforeach; ?>
            </div>
        </div>
    </section>
    <!-- Team Four Start -->

<?php endif; ?>