<?php

$this->start_controls_section(
    'layout_four_content',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_four']
        ]
    ]
);

$team = new \Elementor\Repeater();

$team->add_control(
    'name',
    [
        'label' => __('Name', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Michale smith', 'ogency-addon'),
        'label_block' => true,
    ]
);

ogency_elementor_heading_option($team, 'Team Name', 'h3', 'layout_four');

$team->add_control(
    'designation',
    [
        'label' => __('Designation', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('Mayor', 'ogency-addon'),
    ]
);

$team->add_control(
    'url',
    [
        'label' => __('Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => true,
        ],
        'show_label' => false,
    ]
);

$team->add_control(
    'social_network',
    [
        'label' => __('Social NetWork', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<a href="https://www.twitter.com"><i class="fab fa-twitter"></i></a>', 'ogency_allowed_tags')
    ]
);


$team->add_control(
    'image',
    [
        'label' => __('Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'team_layout_four_list',
    [
        'label' => __('Team List', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $team->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ name }}}',
    ]
);

$this->end_controls_section();
