<?php

$this->start_controls_section(
    'layout_five_content_section',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_five'
        ]
    ]
);


$this->add_control(
    'layout_five_sec_title',
    [
        'label' => __('Section Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Awesome Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Title', 'h2', 'layout_five');

$this->add_control(
    'layout_five_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Awesome Sub Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_five');

$this->add_control(
    'layout_five_summary',
    [
        'label' => __('Section Summary ', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Text', 'ogency-addon'),
    ]
);

$layout_five_service = new \Elementor\Repeater();

$layout_five_service->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Awesome Title', 'ogency-addon'),
        'label_block' => true,
    ]
);

ogency_elementor_heading_option($layout_five_service, 'Service Title', 'h3', 'layout_five');

$layout_five_service->add_control(
    'summary',
    [
        'label' => __('Summary', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Default Text', 'ogency-addon'),
        'label_block' => true,
    ]
);

$layout_five_service->add_control(
    'icon',
    [
        'label' => __('Section Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-heart',
            'library' => 'custom-icon',
        ],
    ]
);

$layout_five_service->add_control(
    'btn_text',
    [
        'label' => __('Button Text', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('More', 'ogency-addon'),
        'label_block' => true,
    ]
);

$layout_five_service->add_control(
    'url',
    [
        'label' => __('Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
    ]
);

$layout_five_service->add_control(
    'btn_icon',
    [
        'label' => __('Url Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-down-right',
            'library' => 'custom-icon',
        ],
    ]
);

$layout_five_service->add_control(
    'image',
    [
        'label' => __('Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->add_control(
    'layout_five_service_items',
    [
        'label' => __('Service Items', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_five_service->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'layout_five_bg_image',
    [
        'label' => __('Background Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->end_controls_section();
