<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Pricing Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);
$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Title', 'h2', 'layout_one');

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'ogency-addon'),
        'default' => __('Default Sub Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Sub Title', 'h5', 'layout_one');

$this->add_control(
    'pricing_layout_one_pricing_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$this->add_control(
    'monthly_heading',
    [
        'label' => __('Monthly Heading', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Monthly', 'ogency-addon'),
        'default' => __('Monthly', 'ogency-addon'),
    ]
);

$this->add_control(
    'yearly_heading',
    [
        'label' => __('Yearly Heading', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Yearly', 'ogency-addon'),
        'default' => __('Yearly', 'ogency-addon'),
    ]
);

$pricing_monthly_list = new \Elementor\Repeater();

$pricing_monthly_list->add_control(
    'plan_title',
    [
        'label' => __('Plan Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Plan', 'ogency-addon'),
        'default' => __('Default Plan', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($pricing_monthly_list, 'Plan Title', 'h4', 'layout_one');

$pricing_monthly_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-pen-tool',
            'library' => 'Custom Icon',
        ],
    ]
);

$pricing_monthly_list->add_control(
    'price',
    [
        'label' => __('Price', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('$30', 'ogency-addon'),
    ]
);


$pricing_monthly_list->add_control(
    'service_title',
    [
        'label' => __('Service Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('Default Service Title', 'ogency-addon'),
    ]
);

$pricing_monthly_list->add_control(
    'service_list',
    [
        'label' => __('Service List', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<li><span class="fa fa-check"></span>10 Days Time</li>', 'ogency_allowed_tags')
    ]
);

$pricing_monthly_list->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Apply Now', 'ogency-addon'),
        'label_block' => true,
    ]
);

$pricing_monthly_list->add_control(
    'url',
    [
        'label' => __('Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'pricing_monthly_list',
    [
        'label' => __('Monthly List', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $pricing_monthly_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ plan_title }}}',
    ]
);

$this->add_control(
    'pricing_layout_one_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$pricing_yearly_list = new \Elementor\Repeater();

$pricing_yearly_list->add_control(
    'plan_title',
    [
        'label' => __('Plan Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Plan', 'ogency-addon'),
        'default' => __('Default Plan', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($pricing_yearly_list, 'Plan Title', 'h4', 'layout_one');

$pricing_yearly_list->add_control(
    'price',
    [
        'label' => __('Price', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('$69', 'ogency-addon'),
    ]
);

$pricing_yearly_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-pen-tool',
            'library' => 'Custom Icon',
        ],
    ]
);

$pricing_yearly_list->add_control(
    'service_title',
    [
        'label' => __('Service Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('Default Service Title', 'ogency-addon'),
    ]
);

$pricing_yearly_list->add_control(
    'service_list',
    [
        'label' => __('Service List', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<li><span class="fa fa-check"></span>10 Days Time</li>', 'ogency_allowed_tags')
    ]
);

$pricing_yearly_list->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Apply Now', 'ogency-addon'),
        'label_block' => true,
    ]
);

$pricing_yearly_list->add_control(
    'url',
    [
        'label' => __('Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'pricing_yearly_list',
    [
        'label' => __('Yearly List', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $pricing_yearly_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ plan_title }}}',
    ]
);

$this->end_controls_section();
