<?php

$this->start_controls_section(
    'content__three_section',
    [
        'label' => __('Portfolio Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_three', 'layout_four', 'layout_five']
        ]
    ]
);

$portfolio_three = new \Elementor\Repeater();

$portfolio_three->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($portfolio_three, 'Portfolio Title', 'h3', 'layout_three');

$portfolio_three->add_control(
    'tag_line',
    [
        'label' => __('Tag Line', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Tag Line', 'ogency-addon'),
        'default' => __('Default Tag Line', 'ogency-addon'),
    ]
);

$portfolio_three->add_control(
    'url',
    [
        'label' => __('Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);


$portfolio_three->add_control(
    'image',
    [
        'label' => __('Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'portfolio_three_list',
    [
        'label' => __('Portfolio List', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $portfolio_three->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
