<?php

//content
$this->start_controls_section(
    'content_one',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Title', 'h2', 'layout_one');


$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'ogency-addon'),
        'default' => __('Default Sub Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_one');


$neighbour_faq = new \Elementor\Repeater();

$neighbour_faq->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
        'label_block' => true,
    ]
);

ogency_elementor_heading_option($neighbour_faq, 'Accordian Title', 'h4', 'layout_one');

$neighbour_faq->add_control(
    'sub_title',
    [
        'label' => __('Sub Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Sub Title', 'ogency-addon'),
        'default' => __('Default Sub Title', 'ogency-addon'),
        'label_block' => true,
    ]
);

$neighbour_faq->add_control(
    'summary',
    [
        'label' => __('Summary', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Summary', 'ogency-addon'),
        'default' => __('Default Summary', 'ogency-addon'),
        'label_block' => true,
    ]
);

$neighbour_faq->add_control(
    'active_status',
    [
        'label' => __('Is active?', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'ogency-addon'),
        'label_off' => __('No', 'ogency-addon'),
        'return_value' => 'yes',
        'default' => 'no',
    ]
);


$this->add_control(
    'neighbour_faq_lists',
    [
        'label' => __('Neighborhood List', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $neighbour_faq->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'bac_image_one',
    [
        'label' => __('Backround Image One', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->add_control(
    'bac_image_two',
    [
        'label' => __('Backround Image Two', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);


$this->end_controls_section();
