<?php

//content
$this->start_controls_section(
    'layout_two_content',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);


$layout_two_faq = new \Elementor\Repeater();

$layout_two_faq->add_control(
    'question',
    [
        'label' => __('Question', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Question', 'ogency-addon'),
        'default' => __('Default Question', 'ogency-addon'),
        'label_block' => true,
    ]
);

ogency_elementor_heading_option($layout_two_faq, 'Question Title', 'h4', 'layout_two');

$layout_two_faq->add_control(
    'answer',
    [
        'label' => __('Answer', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Answer', 'ogency-addon'),
        'default' => __('Default Answer', 'ogency-addon'),
        'label_block' => true,
    ]
);

$layout_two_faq->add_control(
    'active_status',
    [
        'label' => __('Is active?', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'ogency-addon'),
        'label_off' => __('No', 'ogency-addon'),
        'return_value' => 'yes',
        'default' => 'no',
    ]
);


$this->add_control(
    'layout_two_faq_lists',
    [
        'label' => __('FAQ', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_faq->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ question }}}',
    ]
);


$this->end_controls_section();
