<?php

//content
$this->start_controls_section(
    'content_one',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);


$award_list = new \Elementor\Repeater();

$award_list->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Best Counseling', 'ogency-addon'),
        'label_block' => true
    ]
);

ogency_elementor_heading_option($award_list, 'Title', 'h4', 'layout_one');

$award_list->add_control(
    'year',
    [
        'label' => __('Year', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add year text', 'ogency-addon'),
        'default' => __('2012', 'ogency-addon'),
        'label_block' => true
    ]
);

$award_list->add_control(
    'content',
    [
        'label' => __('Summary', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Summary', 'ogency-addon'),
        'default' => __('Default Summary', 'ogency-addon'),
    ]
);

$award_list->add_control(
    'icon_image',
    [
        'label' => __('Icon Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'award_list',
    [
        'label' => __('Award Lists', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $award_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'layout_one_background_image',
    [
        'label' => __('Background Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_one_background_image_teo',
    [
        'label' => __('Background Image Two', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_one_front_image',
    [
        'label' => __('Front Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$award_list_two = new \Elementor\Repeater();

$award_list_two->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Best Counseling', 'ogency-addon'),
        'label_block' => true
    ]
);

ogency_elementor_heading_option($award_list_two, 'Title', 'h4', 'layout_one');

$award_list_two->add_control(
    'year',
    [
        'label' => __('Year', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add year text', 'ogency-addon'),
        'default' => __('2012', 'ogency-addon'),
        'label_block' => true
    ]
);

$award_list_two->add_control(
    'content',
    [
        'label' => __('Summary', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Summary', 'ogency-addon'),
        'default' => __('Default Summary', 'ogency-addon'),
    ]
);

$award_list_two->add_control(
    'icon_image',
    [
        'label' => __('Icon Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'award_list_two',
    [
        'label' => __('Award List', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $award_list_two->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);


$this->end_controls_section();
